INPUT(&&)


/* these symbols only for encapsulation; the GCC linker won't allow symbols in the MEMORY directive... */

_FLASH_PHYS_START = 0x08000000;
FLASH_PHYS_LENGTH = 1024K;

RAM_PHYS_START = 0x20000000;
RAM_BL_RESERVED_LENGTH = 0x1000;
RAM_PHYS_LENGTH = 128K;

FLASHLIMIT_BL = 4K;

/* Specify the memory areas */
MEMORY
{
  FLASH_BL (rx)   : ORIGIN = 0x08000000, LENGTH = 4K 
  FLASH_FW (rx)   : ORIGIN = 0x08000000+4K, LENGTH = 1024K - 4K
  RAM_BL (xrw)       : ORIGIN = 0x20000000, LENGTH = 4K 
  RAM_FW (xrw)       : ORIGIN = 0x20000000+4K, LENGTH = 128K - 4K
}

/* Define output sections */
SECTIONS
{
  /* The startup code goes first into FLASH */
  .isr_vector_bl (NOLOAD) :
  {
    . = ALIGN(4);
    _flashstart_bl = .;
    KEEP(*(.isr_vector_bl)) /* Startup code */
    . = ALIGN(4);
  } >FLASH_BL
  
  .mcb_bl (NOLOAD) :  
  {
    . = ALIGN(4);
    g_bl_mcb = .;
    KEEP(*(.mcb_bl))
    . = ALIGN(4);
  } >FLASH_BL


  CODEFENCE = 0x08000000+FLASHLIMIT_BL;


  .isr_vector_fw :
  {
    . = ALIGN(4);
    KEEP(*(.isr_vector_fw)) /* Startup code */
    . = ALIGN(4);
  } >FLASH_FW
  
  .mcb_fw :  
  {
    . = ALIGN(4);
    g_fw_mcb = .;
    KEEP(*(.mcb_fw))
    . = ALIGN(4);
  } >FLASH_FW

  /* The program code and other data goes into FLASH */
  .text :
  {
    . = ALIGN(4);
    _text = .;        /* define a global symbols at beginning of code */
    *(.text)           /* .text sections (code) */
    *(.text*)          /* .text* sections (code) */
    *(.rodata)         /* .rodata sections (constants, strings, etc.) */
    *(.rodata*)        /* .rodata* sections (constants, strings, etc.) */
    *(.glue_7)         /* glue arm to thumb code */
    *(.glue_7t)        /* glue thumb to arm code */
    *(.eh_frame)


    . = ALIGN(4);
    _etext = .;        /* define a global symbols at end of code */
  } >FLASH_FW



  /* Initialized data sections goes into RAM, load LMA copy after code */
  .data : AT ( _sidata )
  {
    . = ALIGN(4);
    _ramstart = .;
    _ramend = . + RAM_PHYS_LENGTH - RAM_BL_RESERVED_LENGTH;
    _sdata = .;        /* create a global symbol at data start */
    _data = .;        /* create a global symbol at data start */
    *(.data)           /* .data sections */
    *(.data*)          /* .data* sections */

    . = ALIGN(4);
    _edata = .;        /* define a global symbol at data end */
  } >RAM_FW

  /* used by the startup to initialize data */
  .initdata (NOLOAD): 
  {
    _sidata = .;
    . += SIZEOF(.data);
    _eidata = .;
  } > FLASH_FW


  /* Uninitialized data section */
  . = ALIGN(4);
  .bss :
  {
    /* This is used by the startup in order to initialize the .bss secion */
    _sbss = .;         /* define a global symbol at bss start */
    _bss = .;         /* define a global symbol at bss start */
    __bss_start__ = _sbss;
    *(.bss)
    *(.bss*)
    *(COMMON)

    . = ALIGN(4);
    _ebss = .;         /* define a global symbol at bss end */
    __bss_end__ = _ebss;
  } >RAM_FW

  /* User_heap_stack section, used to check that there is enough RAM left */
  ._user_heap_stack :
  {
    . = ALIGN(4);
    PROVIDE ( end = . );
    PROVIDE ( _end = . );
/*    . = . + _Min_Heap_Size;
    . = . + _Min_Stack_Size; */
    . = ALIGN(4);
  } >RAM_FW

  /* MEMORY_bank1 section, code must be located here explicitly            */
  /* Example: extern int foo(void) __attribute__ ((section (".mb1text"))); */

  /* Remove information from the standard libraries */
  /DISCARD/ :
  {
    libc.a ( * )
    libm.a ( * )
    libgcc.a ( * )
  }

}

